@extends('layouts.app')

@section('title', 'Edit Profile')

@section('content')
<div class="profile-container">
    <div class="profile-content">
        <div class="profile-section">
            <div class="info-card">
                <form action="{{ route('profile.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <!-- Banner Upload -->
                    <div class="form-group">
                        <label for="banner">Profile Banner</label>
                        
                        <div class="banner-preview">
                            @if($user->banner)
                                <img src="{{ Storage::url('user_banners/' . $user->banner) }}" alt="Current Banner" class="current-banner-img">
                                <div class="banner-actions">
                                    <a href="{{ route('profile.delete-banner') }}" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to remove your banner?')">
                                        <i class="fas fa-trash"></i> Remove Banner
                                    </a>
                                </div>
                            @else
                                <div class="no-banner">
                                    <i class="fas fa-image"></i>
                                    <p>No banner image set</p>
                                </div>
                            @endif
                        </div>
                        
                        <input type="file" name="banner" id="banner" class="form-control mt-3 @error('banner') is-invalid @enderror">
                        
                        @error('banner')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        
                        <small class="form-text text-muted">Recommended size: 1200×300px. Maximum size: 2MB. Supported formats: JPG, PNG, GIF.</small>
                    </div>
                    
                    <!-- Name -->
                    <div class="form-group">
                        <label for="name">Display Name</label>
                        <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" 
                               value="{{ old('name', $user->name) }}">
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <!-- Slug -->
                    <div class="form-group">
                        <label for="slug">Profile Slug</label>
                        <input type="text" name="slug" id="slug" class="form-control @error('slug') is-invalid @enderror" 
                               value="{{ old('slug', $user->slug) }}">
                        @error('slug')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">This will be used in your profile URL: {{ config_value('site_url', 'example.com') }}/users/your-slug</small>
                    </div>
                    
                    <!-- Avatar Info -->
                    <div class="form-info">
                        <div class="avatar-preview">
                            <img src="{{ $user->avatar }}" alt="Avatar" class="avatar-image">
                        </div>
                        <div class="avatar-info">
                            <p>Your avatar is synced with your Steam profile. To change it, update your Steam profile.</p>
                            <a href="{{ $user->getSteamProfileUrl() }}" target="_blank" class="steam-link">
                                <i class="fab fa-steam"></i> Go to Steam Profile
                            </a>
                        </div>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Save Changes
                        </button>
                        <a href="{{ route('profile.show') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Preview banner image before upload
        const bannerInput = document.getElementById('banner');
        if (bannerInput) {
            bannerInput.addEventListener('change', function() {
                if (this.files && this.files[0]) {
                    const reader = new FileReader();
                    
                    reader.onload = function(e) {
                        let bannerPreview = document.querySelector('.banner-preview');
                        
                        // Clear the current content
                        bannerPreview.innerHTML = `
                            <img src="${e.target.result}" alt="Banner Preview" class="current-banner-img">
                            <div class="banner-actions">
                                <span class="text-muted">Preview - Save to confirm</span>
                            </div>
                        `;
                    }
                    
                    reader.readAsDataURL(this.files[0]);
                }
            });
        }
    });
</script>
@endpush